/*------------------------------------------------------------------------------*
 * File Name: XFCore.h															*
 * Creation: Sim 03-20-2007														*
 * Purpose: Origin C Header Files												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 08-26-2008 QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE		*
 *	Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE				*
 *	Sim 01-13-2009 XFWIZ_CHANGE_PARAM_MAY_CHANGE_THEME_AND_IO_RANGE				*
 *	Folger 01/19/09 QA80-12969 PA_FITTING_SUPPORT_ANALYSIS_TEMPLATE				*
 *	Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
 *	Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE					*
 *------------------------------------------------------------------------------*/

#ifndef __XF_CORE_H__
#define __XF_CORE_H__

class XFCore
{
public:
	XFCore();
public:
	bool		Load(LPCSTR lpcszXFName);
	virtual	bool		Apply();
	//bool		Undo();

	int			OnBeforeExecute(int nEventID = XF_GETN_SIMPLE);
	Function	GetEventHandler();
	bool		GetGetN(TreeNode &trGetN);
	string		GetXFName(string& strXFDescription = NULL);
	bool		SetDefautlValue();
	
	//void		GetInputOutputs(DataRange& drInput, Array<DataRange&>& arrdrOutputs);
	const Array<DataRange&>*		GetInputs();
	const Array<DataRange&>*		GetOutputs();
	bool		UpdateOutputUIDs(vector<int>& vUIDs); ///---Sim 08-26-2008 QA80-12093 REUSE_REPORT_DATA_IN_XFWIZ_WHEN_RECALCULATE
	
	//void		SetTargetPage(const Page& pg);
	//bool		GetTargetPage(Page& pg);

	void		SetXFWizNavigation(DWORD dwXFWizNavigationHandler);
	DWORD		GetXFWizNavigation();
	
	void		SetXFMode(DWORD dwXFMode);
	void		SetExecute(DWORD dwExecute);
	void		SetRecalculate(int nAddRecalculate);
	void		SetResultsLogOutput(int nAddResultsLogOutput);
	
	void		SetClassName(LPCSTR lpcszClassName) {m_strClassName = lpcszClassName;}
	//virtual bool	GetDefaultSteps(StringArray &saXFNames) {ASSERT(FALSE); return false;}
	//virtual string	GetClassName() {ASSERT(FALSE); return "";}
	//virtual bool	GetOPEntry(string &strFile, string &strFunc) {return false;}
	//
	//bool		GetStepLabels(const StringArray& saXFNames, StringArray& saXFLables);
	//
	//virtual double	GetVersion();
	
	virtual bool	Done(bool bFinish = true) { return true; } ///---Sim 02-12-2009 FIX_SET_RANGE_AS_INPUT_INPUT_CAUSE_CREATE_OP_FAIL_AND_PA_FINISH_BROKEN
	
	virtual void	Destroy() {}
	
	///------ Folger 01/19/09 QA80-12969 PA_FITTING_SUPPORT_ANALYSIS_TEMPLATE
	void		SetXFWizOp(DWORD dwUIDOp)		{ m_dwUIDOp = dwUIDOp; }
	DWORD		GetXFWizOp()					{ return m_dwUIDOp; }
	///------ End PA_FITTING_SUPPORT_ANALYSIS_TEMPLATE

	///------ Folger 12/18/09 QA81-14860 REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
	virtual	BOOL	CheckUpdateOperationTree(DWORD dwUIDOp)		{ ASSERT(FALSE); return FALSE; }
	///------ End REUID_PA_OUTPUTS_FOR_AUTO_UPDATE
	
protected:
	//bool		SetExecValsInfo2GetNTree(TreeNode& trGetN, const TreeNode& trExecuteGetN);
	
	//bool		SetMapStepLabels(const StringArray& saMapXFNames, const StringArray& saMapXFLabels);
	void		InitGetNSetting(TreeNode& trGetN);
	
protected:
	XFBase		m_XF;
	TreeNode 	m_trXF;
	DWORD		m_dwXFMode;
	DWORD		m_dwExecute;
	//int			m_nGetNType;
	int			m_nAddRecalculate;
	int			m_nAddResultsLogOutput;
	
	Tree		m_trRootGetN;
	TreeNode	m_trGetN;
	Tree		m_trExecuteGetN;
	
	Page		m_TargetPage;
	DWORD		m_dwXFWizNavigationHandler;
	
	//DataRange	m_drInput;
	Array<DataRange&> m_arrdrInputs;
	Array<DataRange&> m_arrdrOutputs;
	
	string		m_strClassName;
	//StringArray m_saMapXFNames;
	//StringArray m_saMapXFLabels;
	
	StringArray	m_vsXFsRecalculateShown; ///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
	
	DWORD		m_dwUIDOp;		///------ Folger 01/19/09 QA80-12969 PA_FITTING_SUPPORT_ANALYSIS_TEMPLATE
private:
	bool		m_bIsRecalculateShown; ///---Sim 01-12-2009 QA80-12946 XFWIZ_SUPPORT_CHANGE_RECALCULATE_MODE
};

#endif		//__XF_CORE_H__
